/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class PuzzleGame
extends MIDlet {
    private static PuzzleGame theGame;
    private static int currentDifficult;
    private static int score;
    private static boolean sound;
    private boolean isPlaying = false;
    private ArrayPoolManager pool = new ArrayPoolManager(1);
    private ArrayPoolManager menuPool = new ArrayPoolManager(1);
    private ArrayPoolManager scorePool = new ArrayPoolManager(1);

    public PuzzleGame() {
        theGame = this;
        this.pool.putObject(new MainScreen());
        this.menuPool.putObject((Object)new MenuScreen());
        this.scorePool.putObject((Object)new ScoreScreen());
    }

    public void startApp() {
        SplashScreen splashScreen = new SplashScreen();
        this.setDisplay((Displayable)splashScreen);
    }

    public void pauseApp() {
        if (this.isPlaying) {
            MainScreen mainScreen = (MainScreen)this.pool.getObject();
            mainScreen.pause();
            this.pool.putObject(mainScreen);
        }
    }

    public void destroyApp(boolean bl) {
    }

    public void setDisplay(Displayable displayable) {
        Display.getDisplay((MIDlet)this).setCurrent(displayable);
    }

    public void showMenu() {
        score = 0;
        currentDifficult = 0;
        MenuScreen menuScreen = (MenuScreen)((Object)this.menuPool.getObject());
        menuScreen.recreate(this);
        this.setDisplay((Displayable)menuScreen);
        this.menuPool.putObject((Object)menuScreen);
    }

    public void showMainScreen() {
        MainScreen mainScreen = (MainScreen)this.pool.getObject();
        mainScreen.recreate(sound, this);
        this.pool.putObject(mainScreen);
        this.setDisplay((Displayable)mainScreen);
        this.isPlaying = true;
    }

    public void showScoreScreen(boolean bl, boolean bl2) {
        ScoreScreen scoreScreen = (ScoreScreen)((Object)this.scorePool.getObject());
        scoreScreen.recreate(score, bl, bl2, this);
        this.setDisplay((Displayable)scoreScreen);
        this.scorePool.putObject((Object)scoreScreen);
        this.isPlaying = false;
    }

    public void showExitScreen() {
        ExitScreen exitScreen = new ExitScreen();
        this.setDisplay((Displayable)exitScreen);
    }

    public static PuzzleGame getGame() {
        return theGame;
    }

    public int getDifficult() {
        return currentDifficult;
    }

    public void setDifficult(int n) {
        currentDifficult = n;
    }

    public void setSound(boolean bl) {
        sound = bl;
    }

    public boolean getSound() {
        return sound;
    }

    public void addScore(int n) {
        score += n;
    }

    public int getScore() {
        return score;
    }

    public void resume() {
        MainScreen mainScreen = (MainScreen)this.pool.getObject();
        this.setDisplay((Displayable)mainScreen);
        mainScreen.pause();
        this.pool.putObject(mainScreen);
        this.isPlaying = true;
    }

    public void exitGame() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    static {
        currentDifficult = 0;
        score = 0;
        sound = false;
    }
}

