/*
 * Decompiled with CFR 0.152.
 */
import GameSound.GameSound;
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainScreen
extends FullCanvas
implements Runnable {
    PuzzleGame puzzleGame;
    int HEIGHT = 320;
    int WIDTH = 240;
    int boardWidth = 0;
    int boardHeight = 0;
    Coordinate imageNums;
    GameSound sound = new GameSound();
    Image[][] image;
    Image[] fadeOutImage;
    boolean[][] visible;
    Coordinate[][] itemCoor;
    int[][] itemCode;
    int level = 0;
    int scoreLV = 0;
    int swapNumber = 11;
    boolean checkSwap = true;
    boolean next = false;
    Coordinate oneCMP;
    Coordinate twoCMP;
    int x;
    int y;
    int itemWidth = 0;
    int itemHeight = 0;
    Coordinate top = new Coordinate(this.x, this.y);
    Coordinate current;
    boolean choice = false;
    long gameTime;
    long wait;
    int delay;
    public long timeRemaining;
    public boolean playing = false;
    Image backImage;
    boolean fade = false;
    private int fadeIn = 5;

    public void recreate(boolean bl, PuzzleGame puzzleGame) {
        this.puzzleGame = puzzleGame;
        this.x = 10;
        this.y = 10;
        this.fade = false;
        this.fadeIn = 5;
        this.oneCMP = new Coordinate(0, 0);
        this.twoCMP = new Coordinate(0, 0);
        this.current = new Coordinate(10, 5);
        this.next = false;
        this.checkSwap = true;
        this.choice = false;
        this.image = new Image[12][12];
        this.visible = new boolean[12][12];
        this.itemCoor = new Coordinate[12][12];
        this.itemCode = new int[12][12];
        this.delay = 100;
        this.playing = false;
        this.setFullScreenMode(true);
        this.level = this.puzzleGame.getDifficult();
        String string = "/Pikachu_" + (this.level + 1) + ".JPG";
        switch (this.level) {
            case 1: {
                this.imageNums = new Coordinate(8, 10);
                this.gameTime = System.currentTimeMillis() + 180000L;
                this.swapNumber = 2;
                this.scoreLV = 7;
                break;
            }
            case 2: {
                this.imageNums = new Coordinate(10, 10);
                this.gameTime = System.currentTimeMillis() + 180000L;
                this.swapNumber = 3;
                this.scoreLV = 10;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                this.imageNums = new Coordinate(10, 10);
                this.gameTime = System.currentTimeMillis() + 180000L + 30000L;
                this.swapNumber = 3;
                this.scoreLV = 15;
                break;
            }
            case 7: 
            case 8: {
                this.imageNums = new Coordinate(10, 10);
                this.gameTime = System.currentTimeMillis() + 180000L + 30000L;
                this.swapNumber = 4;
                this.scoreLV = 15;
                break;
            }
            case 10: {
                this.imageNums = new Coordinate(10, 10);
                this.gameTime = System.currentTimeMillis() + 240000L;
                this.swapNumber = 4;
                this.scoreLV = 15;
                break;
            }
            default: {
                this.imageNums = new Coordinate(8, 8);
                this.gameTime = System.currentTimeMillis() + 120000L;
                this.swapNumber = 1;
                this.scoreLV = 5;
            }
        }
        this.sound.setMute(!bl);
        try {
            this.backImage = Image.createImage((String)string);
            Image image = Image.createImage((String)"/fade.PNG");
            this.fadeOutImage = this.ExtractImage(image, 5, 1);
            this.setImage();
        }
        catch (IOException iOException) {
            System.out.print("Can't load Image");
        }
        this.wait = System.currentTimeMillis();
        this.start();
    }

    public void setImage() {
        int n;
        Image[] imageArray = new Image[30];
        for (n = 0; n < 30; ++n) {
            try {
                imageArray[n] = Image.createImage((String)("/cellImage/pikachu" + (n + 1) + ".gif"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.itemWidth = imageArray[0].getWidth();
        this.itemHeight = imageArray[0].getHeight();
        this.boardWidth = this.imageNums.x * this.itemWidth;
        this.boardHeight = this.imageNums.y * this.itemHeight;
        this.x = (this.WIDTH - this.imageNums.x * this.itemWidth) / 2;
        this.top = new Coordinate(this.x, this.y);
        n = 0;
        for (int i = 0; i < this.imageNums.y; ++i) {
            for (int j = 0; j < this.imageNums.x; ++j) {
                this.image[i][j] = imageArray[n];
                this.visible[i][j] = true;
                this.itemCoor[i][j] = new Coordinate(this.top.x + this.itemWidth * j, this.top.y + this.itemHeight * i);
                this.itemCode[i][j] = n++;
                if (n != this.imageNums.x * this.imageNums.y / 4) continue;
                n = 0;
            }
        }
        this.swap();
        this.swap();
        this.sound.Swap();
    }

    protected void swap() {
        Random random = new Random();
        int n = Math.abs(random.nextInt()) % 300;
        for (int i = 0; i < n; ++i) {
            int n2 = Math.abs(random.nextInt()) % (this.imageNums.x * this.imageNums.y);
            int n3 = Math.abs(random.nextInt()) % (this.imageNums.x * this.imageNums.y);
            while (!this.visible[n2 / this.imageNums.x][n2 % this.imageNums.x] || !this.visible[n3 / this.imageNums.x][n3 % this.imageNums.x]) {
                n2 = Math.abs(random.nextInt()) % (this.imageNums.x * this.imageNums.y);
                n3 = Math.abs(random.nextInt()) % (this.imageNums.x * this.imageNums.y);
            }
            this.switchImg(n2 / this.imageNums.x, n2 % this.imageNums.x, n3 / this.imageNums.x, n3 % this.imageNums.x);
        }
    }

    protected void switchImg(int n, int n2, int n3, int n4) {
        Image image = this.image[n][n2];
        int n5 = this.itemCode[n][n2];
        boolean bl = this.visible[n][n2];
        this.image[n][n2] = this.image[n3][n4];
        this.itemCode[n][n2] = this.itemCode[n3][n4];
        this.visible[n][n2] = this.visible[n3][n4];
        this.image[n3][n4] = image;
        this.itemCode[n3][n4] = n5;
        this.visible[n3][n4] = bl;
    }

    protected void VsortImg() {
        for (int i = 0; i < this.imageNums.x; ++i) {
            for (int j = 0; j < this.imageNums.y; ++j) {
                if (this.visible[j][i]) continue;
                int n = j;
                while (++n < this.imageNums.y && !this.visible[n][i]) {
                }
                this.switchImg(j, i, n, i);
            }
        }
    }

    protected void HsortImg() {
        for (int i = 0; i < this.imageNums.y; ++i) {
            for (int j = 0; j < this.imageNums.x; ++j) {
                if (this.visible[i][j]) continue;
                int n = j;
                while (++n < this.imageNums.x && !this.visible[i][n]) {
                }
                this.switchImg(i, j, i, n);
            }
        }
    }

    protected void HJsortImg() {
        for (int i = 0; i < this.imageNums.y; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.imageNums.x / 2; ++n2) {
                if (this.visible[i][n2]) continue;
                n = n2;
                while (++n < this.imageNums.x / 2 && !this.visible[i][n]) {
                }
                if (n >= this.imageNums.x / 2) continue;
                this.switchImg(i, n2, i, n);
            }
            for (n2 = this.imageNums.x - 1; n2 >= this.imageNums.x / 2; --n2) {
                if (this.visible[i][n2]) continue;
                n = n2;
                while (--n >= this.imageNums.x / 2 && !this.visible[i][n]) {
                }
                if (n < this.imageNums.x / 2) continue;
                this.switchImg(i, n2, i, n);
            }
        }
    }

    protected void VJsortImg() {
        for (int i = 0; i < this.imageNums.x; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.imageNums.y / 2; ++n2) {
                if (this.visible[n2][i]) continue;
                n = n2;
                while (++n < this.imageNums.y / 2 && !this.visible[n][i]) {
                }
                if (n >= this.imageNums.y / 2) continue;
                this.switchImg(n2, i, n, i);
            }
            for (n2 = this.imageNums.y - 1; n2 >= this.imageNums.y / 2; --n2) {
                if (this.visible[n2][i]) continue;
                n = n2;
                while (--n >= this.imageNums.y / 2 && !this.visible[n][i]) {
                }
                if (n < this.imageNums.y / 2) continue;
                this.switchImg(n2, i, n, i);
            }
        }
    }

    protected void HCsortImg() {
        for (int i = 0; i < this.imageNums.y; ++i) {
            int n;
            int n2;
            for (n2 = this.imageNums.x / 2 - 1; n2 >= 0; --n2) {
                if (this.visible[i][n2]) continue;
                n = n2;
                while (--n >= 0 && !this.visible[i][n]) {
                }
                if (n < 0) continue;
                this.switchImg(i, n2, i, n);
            }
            for (n2 = this.imageNums.x / 2; n2 < this.imageNums.x; ++n2) {
                if (this.visible[i][n2]) continue;
                n = n2;
                while (++n < this.imageNums.x && !this.visible[i][n]) {
                }
                if (n >= this.imageNums.x) continue;
                this.switchImg(i, n2, i, n);
            }
        }
    }

    protected void VCsortImg() {
        for (int i = 0; i < this.imageNums.x; ++i) {
            int n;
            int n2;
            for (n2 = this.imageNums.y / 2 - 1; n2 >= 0; --n2) {
                if (this.visible[n2][i]) continue;
                n = n2;
                while (--n >= 0 && !this.visible[n][i]) {
                }
                if (n < 0) continue;
                this.switchImg(n2, i, n, i);
            }
            for (n2 = this.imageNums.y / 2; n2 < this.imageNums.y; ++n2) {
                if (this.visible[n2][i]) continue;
                n = n2;
                while (++n < this.imageNums.y && !this.visible[n][i]) {
                }
                if (n >= this.imageNums.y) continue;
                this.switchImg(n2, i, n, i);
            }
        }
    }

    protected boolean checkRule(Coordinate coordinate, Coordinate coordinate2) {
        if (!coordinate.compare(coordinate2)) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n = this.findPosition((int)coordinate.x, (int)coordinate.y).x;
            n2 = this.findPosition((int)coordinate.x, (int)coordinate.y).y;
            n3 = this.findPosition((int)coordinate2.x, (int)coordinate2.y).x;
            n4 = this.findPosition((int)coordinate2.x, (int)coordinate2.y).y;
            if (this.visible[n][n2] && this.visible[n3][n4] && this.itemCode[n][n2] == this.itemCode[n3][n4]) {
                this.visible[n][n2] = false;
                this.visible[n3][n4] = false;
                if (!this.checkPath(n, n2, n3, n4)) {
                    this.visible[n][n2] = true;
                    this.visible[n3][n4] = true;
                    return false;
                }
                this.visible[n][n2] = true;
                this.visible[n3][n4] = true;
                return true;
            }
        }
        return false;
    }

    protected Coordinate findPosition(int n, int n2) {
        Coordinate coordinate = new Coordinate(n, n2);
        for (int i = 0; i < this.imageNums.y; ++i) {
            for (int j = 0; j < this.imageNums.x; ++j) {
                if (!this.itemCoor[i][j].compare(coordinate)) continue;
                coordinate = new Coordinate(i, j);
                return coordinate;
            }
        }
        coordinate = new Coordinate(-1, -1);
        return coordinate;
    }

    protected boolean checkPath(int n, int n2, int n3, int n4) {
        if (!this.visible[n][0] && this.isDirect(n, n2, n, 0) && !this.visible[n3][0] && this.isDirect(n3, n4, n3, 0)) {
            return true;
        }
        if (!this.visible[n][this.imageNums.x - 1] && this.isDirect(n, n2, n, this.imageNums.x - 1) && !this.visible[n3][this.imageNums.x - 1] && this.isDirect(n3, n4, n3, this.imageNums.x - 1)) {
            return true;
        }
        if (!this.visible[0][n2] && this.isDirect(n, n2, 0, n2) && !this.visible[0][n4] && this.isDirect(n3, n4, 0, n4)) {
            return true;
        }
        if (!this.visible[this.imageNums.y - 1][n2] && this.isDirect(n, n2, this.imageNums.y - 1, n2) && !this.visible[this.imageNums.y - 1][n4] && this.isDirect(n3, n4, this.imageNums.y - 1, n4)) {
            return true;
        }
        for (int i = 0; i < 10; ++i) {
            if (!this.visible[i][n2] && this.isDirect(n, n2, i, n2) && !this.visible[i][n4] && this.isDirect(n3, n4, i, n4) && this.isDirect(i, n2, i, n4)) {
                return true;
            }
            if (this.visible[n][i] || !this.isDirect(n, n2, n, i) || this.visible[n3][i] || !this.isDirect(n3, n4, n3, i) || !this.isDirect(n, i, n3, i)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDirect(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n == n3 && n2 == n4) {
            bl = true;
        } else {
            int n5;
            if (n == n3) {
                if (Math.abs(n2 - n4) == 1) {
                    bl = true;
                } else {
                    n5 = 0;
                    bl = true;
                    n5 += (n2 - n4) / Math.abs(n2 - n4);
                    while (n4 + n5 != n2) {
                        if (this.visible[n][n4 + n5]) {
                            bl = false;
                        }
                        n5 += (n2 - n4) / Math.abs(n2 - n4);
                    }
                }
            }
            if (n2 == n4) {
                if (Math.abs(n - n3) == 1) {
                    bl = true;
                } else {
                    n5 = 0;
                    bl = true;
                    n5 = (n - n3) / Math.abs(n - n3);
                    while (n3 + n5 != n) {
                        if (this.visible[n3 + n5][n2]) {
                            bl = false;
                        }
                        n5 += (n - n3) / Math.abs(n - n3);
                    }
                }
            }
        }
        return bl;
    }

    public void start() {
        this.gameTime += System.currentTimeMillis() - this.wait;
        this.playing = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        while (this.playing) {
            if (this.checkEndGame()) {
                this.stop();
                break;
            }
            this.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                System.out.print("Unable thread.sleep");
            }
        }
    }

    public void pause() {
        if (this.playing) {
            this.wait = System.currentTimeMillis();
            this.playing = false;
            this.puzzleGame.showScoreScreen(true, false);
        } else {
            this.start();
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Runtime.getRuntime().gc();
        graphics.setColor(0, 0, 255);
        graphics.drawImage(this.backImage, 0, 0, 20);
        Font font = Font.getFont((int)32, (int)0, (int)0);
        graphics.setFont(font);
        if (!this.choice) {
            this.current = new Coordinate(this.x, this.y);
        }
        for (int i = 0; i < this.imageNums.y; ++i) {
            for (n2 = 0; n2 < this.imageNums.x; ++n2) {
                if (!this.visible[i][n2]) continue;
                if (this.findPosition(this.x, this.y).compare(i, n2)) {
                    graphics.drawImage(this.image[i][n2], this.itemCoor[i][n2].x - 2, this.itemCoor[i][n2].y - 2, 20);
                    continue;
                }
                graphics.drawImage(this.image[i][n2], this.itemCoor[i][n2].x, this.itemCoor[i][n2].y, 20);
            }
        }
        if (this.fade && this.fadeIn != 0) {
            int[] nArray = new int[this.fadeOutImage[5 - this.fadeIn].getHeight() * this.fadeOutImage[5 - this.fadeIn].getWidth()];
            this.fadeOutImage[5 - this.fadeIn].getRGB(nArray, 0, this.fadeOutImage[5 - this.fadeIn].getWidth(), 0, 0, this.fadeOutImage[5 - this.fadeIn].getWidth(), this.fadeOutImage[5 - this.fadeIn].getHeight());
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2] & 0xFFFFFF;
                if (n < 0xF5F5F5) continue;
                nArray[n2] = n += 0;
            }
            Image image = Image.createRGBImage((int[])nArray, (int)this.fadeOutImage[5 - this.fadeIn].getWidth(), (int)this.fadeOutImage[5 - this.fadeIn].getHeight(), (boolean)true);
            graphics.drawImage(image, this.oneCMP.x, this.oneCMP.y, 20);
            graphics.drawImage(image, this.twoCMP.x, this.twoCMP.y, 20);
            --this.fadeIn;
        }
        if (this.fadeIn == 0) {
            this.fadeIn = 5;
            this.fade = false;
            if (this.level == 3) {
                this.VsortImg();
            }
            if (this.level == 4) {
                this.HsortImg();
            }
            if (this.level == 5) {
                this.VJsortImg();
            }
            if (this.level == 6) {
                this.HJsortImg();
            }
            if (this.level == 7) {
                this.VCsortImg();
            }
            if (this.level == 8) {
                this.HCsortImg();
            }
            if (this.level == 9) {
                this.VsortImg();
                this.HsortImg();
            }
            if (this.level == 10) {
                this.VCsortImg();
                this.HCsortImg();
            }
        }
        if (!this.visible[this.findPosition((int)this.x, (int)this.y).x][this.findPosition((int)this.x, (int)this.y).y]) {
            graphics.setColor(255, 100, 0);
            graphics.drawRect(this.x, this.y, this.itemWidth, this.itemHeight);
            graphics.setColor(100, 255, 100);
            graphics.drawRect(this.x + 1, this.y + 1, this.itemWidth - 2, this.itemHeight - 2);
        } else {
            graphics.setColor(255, 100, 0);
            graphics.drawRect(this.x - 2, this.y - 2, this.itemWidth, this.itemHeight);
            graphics.setColor(100, 255, 100);
            graphics.drawRect(this.x - 1, this.y - 1, this.itemWidth - 2, this.itemHeight - 2);
        }
        if (this.choice && (System.currentTimeMillis() / 100L % 4L == 0L || System.currentTimeMillis() / 100L % 4L == 1L)) {
            int[] nArray = new int[this.itemWidth * this.itemHeight];
            for (int i = 0; i < nArray.length; ++i) {
                n = 0xF5F5F5;
                nArray[i] = n += 0x7C000000;
            }
            Image image = Image.createRGBImage((int[])nArray, (int)this.itemWidth, (int)this.itemHeight, (boolean)true);
            if (this.current.compare(this.x, this.y)) {
                graphics.setColor(255, 100, 0);
                graphics.drawRect(this.current.x - 2, this.current.y - 2, this.itemWidth, this.itemHeight);
                graphics.setColor(100, 255, 100);
                graphics.drawRect(this.current.x - 1, this.current.y - 1, this.itemWidth - 2, this.itemHeight - 2);
                graphics.drawImage(image, this.current.x - 2, this.current.y - 2, 20);
            } else {
                graphics.setColor(255, 100, 0);
                graphics.drawRect(this.current.x, this.current.y, this.itemWidth, this.itemHeight);
                graphics.setColor(100, 255, 100);
                graphics.drawRect(this.current.x + 1, this.current.y + 1, this.itemWidth - 2, this.itemHeight - 2);
                graphics.drawImage(image, this.current.x, this.current.y, 20);
            }
        }
        switch (this.level) {
            case 0: {
                graphics.setColor(255, 255, 0);
                break;
            }
            case 1: {
                graphics.setColor(255, 255, 0);
                break;
            }
            case 2: {
                graphics.setColor(255, 255, 0);
                break;
            }
            case 3: {
                graphics.setColor(255, 255, 0);
                break;
            }
            case 4: {
                graphics.setColor(255, 255, 0);
                break;
            }
            case 5: {
                graphics.setColor(0, 0, 255);
                break;
            }
            case 6: {
                graphics.setColor(0, 255, 0);
            }
            case 7: {
                graphics.setColor(255, 255, 100);
                break;
            }
            case 8: {
                graphics.setColor(100, 255, 0);
                break;
            }
            case 9: {
                graphics.setColor(0, 255, 0);
                break;
            }
            default: {
                graphics.setColor(255, 255, 255);
            }
        }
        if (!this.checkSwap) {
            graphics.setColor(255, 0, 0);
            graphics.drawString("Can't swap!", 0, this.HEIGHT - 25, 36);
            this.checkSwap = true;
        } else {
            graphics.drawString("Swap: " + this.swapNumber, 0, this.HEIGHT - 25, 36);
        }
        graphics.drawString("Score: " + this.puzzleGame.getScore(), this.WIDTH, this.HEIGHT - 25, 40);
        this.timeRemaining = (this.gameTime - System.currentTimeMillis()) / 1000L;
        graphics.drawString("Time: " + this.timeRemaining, 0, this.HEIGHT - 2, 36);
        graphics.drawString("Level " + (this.puzzleGame.getDifficult() + 1), this.WIDTH, this.HEIGHT - 2, 40);
    }

    public void keyPressed(int n) {
        Runtime.getRuntime().gc();
        switch (n) {
            case -1: 
            case 50: {
                if (this.y > this.itemHeight) {
                    this.y -= this.itemHeight;
                    this.sound.Move();
                    break;
                }
                this.y += (this.imageNums.y - 1) * this.itemHeight;
                this.sound.Move();
                break;
            }
            case -2: 
            case 56: {
                if (this.y < this.boardHeight - this.itemHeight) {
                    this.y += this.itemHeight;
                    this.sound.Move();
                    break;
                }
                this.y -= (this.imageNums.y - 1) * this.itemHeight;
                break;
            }
            case -3: 
            case 52: {
                if (this.x > (this.WIDTH - this.imageNums.x * this.itemWidth) / 2) {
                    this.x -= this.itemWidth;
                    this.sound.Move();
                    break;
                }
                this.x += (this.imageNums.x - 1) * this.itemWidth;
                this.sound.Move();
                break;
            }
            case -4: 
            case 54: {
                if (this.x < this.boardWidth - this.itemWidth + (this.WIDTH - this.imageNums.x * this.itemWidth) / 2) {
                    this.x += this.itemWidth;
                    this.sound.Move();
                    break;
                }
                this.x -= (this.imageNums.x - 1) * this.itemWidth;
                this.sound.Move();
                break;
            }
            case 49: {
                if (this.swapNumber > 0) {
                    this.swap();
                    --this.swapNumber;
                    this.puzzleGame.addScore(-4 * this.scoreLV);
                    this.sound.Swap();
                    break;
                }
                this.checkSwap = false;
                break;
            }
            case 42: {
                this.sound.toggle();
                break;
            }
            case -6: {
                this.pause();
                break;
            }
            case -7: {
                this.pause();
                break;
            }
            case -5: 
            case 53: {
                if (this.choice) {
                    this.choice = false;
                    if (!this.visible[this.findPosition((int)this.x, (int)this.y).x][this.findPosition((int)this.x, (int)this.y).y] || this.oneCMP.compare(this.x, this.y)) break;
                    this.twoCMP = new Coordinate(this.x, this.y);
                    if (this.checkRule(this.oneCMP, this.twoCMP)) {
                        this.fade = true;
                        this.puzzleGame.addScore(this.scoreLV);
                        this.visible[this.findPosition((int)this.oneCMP.x, (int)this.oneCMP.y).x][this.findPosition((int)this.oneCMP.x, (int)this.oneCMP.y).y] = false;
                        this.visible[this.findPosition((int)this.twoCMP.x, (int)this.twoCMP.y).x][this.findPosition((int)this.twoCMP.x, (int)this.twoCMP.y).y] = false;
                        this.sound.CanMove();
                        break;
                    }
                    this.sound.CantMove();
                    break;
                }
                if (!this.visible[this.findPosition((int)this.x, (int)this.y).x][this.findPosition((int)this.x, (int)this.y).y]) break;
                this.choice = true;
                this.oneCMP = new Coordinate(this.x, this.y);
                break;
            }
        }
        this.repaint();
    }

    public boolean checkEndGame() {
        this.timeRemaining = (this.gameTime - System.currentTimeMillis()) / 1000L;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.timeRemaining <= 0L || !this.visible[i][j]) continue;
                return false;
            }
        }
        if (this.timeRemaining <= 0L && this.playing) {
            return true;
        }
        this.next = true;
        return true;
    }

    public void stop() {
        this.puzzleGame.addScore((int)(this.timeRemaining / 10L * (long)this.scoreLV));
        this.playing = false;
        this.puzzleGame.showScoreScreen(false, this.next);
        Runtime.getRuntime().gc();
    }

    public final Image[] ExtractImage(Image image, int n, int n2) {
        int n3 = 0;
        Image[] imageArray = new Image[n2 * n];
        int n4 = image.getWidth() / n;
        int n5 = image.getHeight() / n2;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                imageArray[n3] = Image.createImage((int)n4, (int)n5);
                imageArray[n3].getGraphics().drawImage(image, -j * n4, -i * n5, 20);
                ++n3;
            }
        }
        return imageArray;
    }

    protected class Coordinate {
        public int x;
        public int y;

        public Coordinate(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public boolean compare(int n, int n2) {
            return this.x == n && this.y == n2;
        }

        public boolean compare(Coordinate coordinate) {
            return this.x == coordinate.x && this.y == coordinate.y;
        }
    }
}

